-- MySQL Administrator dump 1.4
--
-- ------------------------------------------------------
-- Server version	5.7.18-log


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;



--
-- Definition of table `availability`
--

DROP TABLE IF EXISTS `availability`;
CREATE TABLE `availability` (
  `idavailability` int(11) NOT NULL AUTO_INCREMENT,
  `media_idmedia` int(11) NOT NULL,
  `startDate` datetime NOT NULL,
  `endDate` datetime NOT NULL,
  `lastUserUpdated` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `lastDateUpdated` datetime NOT NULL,
  PRIMARY KEY (`idavailability`),
  KEY `fk_availability_media1_idx` (`media_idmedia`),
  CONSTRAINT `fk_availability_media1` FOREIGN KEY (`media_idmedia`) REFERENCES `media` (`idmedia`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `availability`
--

/*!40000 ALTER TABLE `availability` DISABLE KEYS */;
INSERT INTO `availability` (`idavailability`,`media_idmedia`,`startDate`,`endDate`,`lastUserUpdated`,`lastDateUpdated`) VALUES 
 (5,1,'2020-03-06 00:00:00','2020-03-16 20:00:00','admin','2020-03-10 13:18:07'),
 (6,2,'2020-03-16 08:00:00','2020-03-26 20:00:00','admin','2020-03-16 13:43:35'),
 (7,1,'2020-03-18 08:00:00','2020-03-26 20:00:00','admin','2020-03-16 19:03:59'),
 (8,4,'2020-03-16 08:00:00','2020-04-14 20:00:00','admin','2020-03-17 11:11:18'),
 (9,5,'2020-03-03 00:00:00','2020-04-24 20:00:00','admin','2020-03-17 11:07:34'),
 (10,6,'2020-03-02 08:00:00','2020-03-31 20:00:00','admin','2020-03-17 11:09:20'),
 (11,3,'2020-03-09 08:00:00','2020-03-31 20:00:00','admin','2020-03-17 11:34:06'),
 (12,7,'2020-03-17 08:00:00','2020-04-21 20:00:00','admin','2020-03-17 11:42:40'),
 (13,8,'2020-03-18 08:00:00','2020-03-19 20:00:00','admin','2020-03-17 11:45:16'),
 (14,8,'2020-03-25 08:00:00','2020-03-27 20:00:00','admin','2020-03-17 11:48:09'),
 (15,9,'2020-07-15 08:00:00','2020-08-12 20:00:00','admin','2020-03-17 12:55:30');
/*!40000 ALTER TABLE `availability` ENABLE KEYS */;


--
-- Definition of table `available_block`
--

DROP TABLE IF EXISTS `available_block`;
CREATE TABLE `available_block` (
  `idavailable_block` int(11) NOT NULL AUTO_INCREMENT,
  `availability_idavailability` int(11) NOT NULL,
  `media_idmedia` int(11) NOT NULL,
  `startDate` datetime NOT NULL,
  `endDate` datetime NOT NULL,
  PRIMARY KEY (`idavailable_block`),
  KEY `fk_available_block_availability1_idx` (`availability_idavailability`),
  KEY `fk_available_block_media1_idx` (`media_idmedia`),
  CONSTRAINT `fk_available_block_availability1` FOREIGN KEY (`availability_idavailability`) REFERENCES `availability` (`idavailability`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_available_block_media1` FOREIGN KEY (`media_idmedia`) REFERENCES `media` (`idmedia`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=127 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `available_block`
--

/*!40000 ALTER TABLE `available_block` DISABLE KEYS */;
INSERT INTO `available_block` (`idavailable_block`,`availability_idavailability`,`media_idmedia`,`startDate`,`endDate`) VALUES 
 (97,5,1,'2020-03-06 00:00:00','2020-03-10 08:00:00'),
 (98,5,1,'2020-03-11 08:00:00','2020-03-16 20:00:00'),
 (99,7,1,'2020-03-18 08:00:00','2020-03-26 20:00:00'),
 (104,10,6,'2020-03-02 08:00:00','2020-03-31 20:00:00'),
 (105,8,4,'2020-03-16 08:00:00','2020-04-14 20:00:00'),
 (106,11,3,'2020-03-09 08:00:00','2020-03-31 20:00:00'),
 (107,12,7,'2020-03-17 08:00:00','2020-04-21 20:00:00'),
 (109,14,8,'2020-03-25 08:00:00','2020-03-27 20:00:00'),
 (112,15,9,'2020-07-15 08:00:00','2020-08-12 20:00:00'),
 (113,6,2,'2020-03-16 08:00:00','2020-03-17 11:00:00'),
 (114,6,2,'2020-03-17 12:00:00','2020-03-26 20:00:00'),
 (115,13,8,'2020-03-19 08:00:00','2020-03-19 20:00:00'),
 (125,9,5,'2020-03-03 00:00:00','2020-03-18 08:00:00'),
 (126,9,5,'2020-03-18 15:00:00','2020-04-24 20:00:00');
/*!40000 ALTER TABLE `available_block` ENABLE KEYS */;


--
-- Definition of table `catalog`
--

DROP TABLE IF EXISTS `catalog`;
CREATE TABLE `catalog` (
  `idcatalog` int(11) NOT NULL AUTO_INCREMENT,
  `super_catalog_idsuper_catalog` int(11) NOT NULL,
  `language` varchar(20) COLLATE utf8_unicode_ci DEFAULT NULL,
  `catalog_num` int(11) NOT NULL,
  `catalog_code` varchar(60) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  `group_num` int(11) DEFAULT NULL,
  PRIMARY KEY (`idcatalog`),
  KEY `fk_catalog_super_catalog1_idx` (`super_catalog_idsuper_catalog`),
  KEY `idx1_catalog` (`super_catalog_idsuper_catalog`,`catalog_num`),
  KEY `idx2_catalog` (`super_catalog_idsuper_catalog`,`catalog_code`),
  KEY `idx3_catalog` (`group_num`,`super_catalog_idsuper_catalog`),
  CONSTRAINT `fk_catalog_super_catalog1` FOREIGN KEY (`super_catalog_idsuper_catalog`) REFERENCES `super_catalog` (`idsuper_catalog`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `catalog`
--

/*!40000 ALTER TABLE `catalog` DISABLE KEYS */;
INSERT INTO `catalog` (`idcatalog`,`super_catalog_idsuper_catalog`,`language`,`catalog_num`,`catalog_code`,`description`,`group_num`) VALUES 
 (1,1,'',0,'English','Inglés',NULL),
 (2,1,'',1,'Spanish','Español',NULL),
 (3,2,'English',0,'Public','',NULL),
 (4,2,'English',1,'Private','',NULL),
 (5,2,'Spanish',0,'Pública','',NULL),
 (6,2,'Spanish',1,'Privada','',NULL),
 (7,3,'English',0,'Not','',NULL),
 (8,3,'English',1,'Yes','',NULL),
 (9,3,'Spanish',0,'No','',NULL),
 (10,3,'Spanish',1,'Sí','',NULL);
/*!40000 ALTER TABLE `catalog` ENABLE KEYS */;


--
-- Definition of table `companies`
--

DROP TABLE IF EXISTS `companies`;
CREATE TABLE `companies` (
  `company_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) COLLATE utf8_unicode_ci DEFAULT '',
  `phone1` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `address1` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `address2` varchar(50) COLLATE utf8_unicode_ci DEFAULT '',
  `city` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `state` varchar(30) COLLATE utf8_unicode_ci DEFAULT '',
  `zip` varchar(11) COLLATE utf8_unicode_ci DEFAULT '',
  `country` varchar(100) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `primary_url` varchar(255) COLLATE utf8_unicode_ci DEFAULT '',
  `owner` int(10) NOT NULL DEFAULT '0',
  `description` mediumtext COLLATE utf8_unicode_ci,
  `email` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `private` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`company_id`),
  KEY `company_name` (`name`),
  KEY `company_owner` (`owner`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `companies`
--

/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
INSERT INTO `companies` (`company_id`,`name`,`phone1`,`fax`,`address1`,`address2`,`city`,`state`,`zip`,`country`,`primary_url`,`owner`,`description`,`email`,`private`) VALUES 
 (0,'Función administrativa','','','','','','','','','',4,'','info@fhumanes.com',0),
 (3,'Company 1','','','','','','','','','',4,'Test','info@fhumanes.com',0);
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;


--
-- Definition of table `config`
--

DROP TABLE IF EXISTS `config`;
CREATE TABLE `config` (
  `config_id` int(10) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `value` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`config_id`),
  UNIQUE KEY `config_name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `config`
--

/*!40000 ALTER TABLE `config` DISABLE KEYS */;
INSERT INTO `config` (`config_id`,`name`,`value`) VALUES 
 (1,'FOLDER_FILES','files'),
 (2,'DATE_RANGE_EVALUATIONS_MIN','-5'),
 (3,'DATE_RANGE_EVALUATIONS_MAX','+30'),
 (4,'URL','http://localhost/reservations/');
/*!40000 ALTER TABLE `config` ENABLE KEYS */;


--
-- Definition of table `departments`
--

DROP TABLE IF EXISTS `departments`;
CREATE TABLE `departments` (
  `dept_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `companies_company_id` int(10) NOT NULL,
  `name` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT '',
  `phone` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `fax` varchar(30) COLLATE utf8_unicode_ci DEFAULT NULL,
  `desc` mediumtext COLLATE utf8_unicode_ci,
  `email` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  PRIMARY KEY (`dept_id`),
  KEY `dept_name` (`name`),
  KEY `fk_departments_companies1_idx` (`companies_company_id`),
  CONSTRAINT `fk_departments_companies1` FOREIGN KEY (`companies_company_id`) REFERENCES `companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Department heirarchy under a company';

--
-- Dumping data for table `departments`
--

/*!40000 ALTER TABLE `departments` DISABLE KEYS */;
INSERT INTO `departments` (`dept_id`,`companies_company_id`,`name`,`phone`,`fax`,`desc`,`email`) VALUES 
 (1,3,'Departament 1','','','','info@fhumanes.com'),
 (2,3,'Departament 2','','','','info@fhumanes.com');
/*!40000 ALTER TABLE `departments` ENABLE KEYS */;


--
-- Definition of table `media`
--

DROP TABLE IF EXISTS `media`;
CREATE TABLE `media` (
  `idmedia` int(11) NOT NULL AUTO_INCREMENT,
  `type_media_idtype_media` int(11) NOT NULL,
  `code` varchar(10) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(200) COLLATE utf8_unicode_ci DEFAULT NULL,
  `files` varchar(500) COLLATE utf8_unicode_ci DEFAULT NULL,
  `owner_id` int(10) DEFAULT NULL,
  PRIMARY KEY (`idmedia`),
  KEY `fk_media_type_media1_idx` (`type_media_idtype_media`),
  KEY `fk_media_users1_idx` (`owner_id`),
  CONSTRAINT `fk_media_type_media1` FOREIGN KEY (`type_media_idtype_media`) REFERENCES `type_media` (`idtype_media`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_media_users1` FOREIGN KEY (`owner_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `media`
--

/*!40000 ALTER TABLE `media` DISABLE KEYS */;
INSERT INTO `media` (`idmedia`,`type_media_idtype_media`,`code`,`title`,`description`,`files`,`owner_id`) VALUES 
 (1,2,'DSK-001','Desk Test 1','Escritorio 2','[{\"name\":\"files\\/AnyChart_alvgzy3s.docx\",\"usrName\":\"AnyChart.docx\",\"size\":736532,\"type\":\"application\\/vnd.openxmlformats-officedocument.wordprocessingml.document\",\"searchStr\":\"AnyChart.docx,!:sStrEnd\"}]',4),
 (2,1,'PRKN-001','Parking 001','','',4),
 (3,6,'PRJT-001','Projector number 001','test','',4),
 (4,2,'DSK-002','Desk Test 2','Escritorio 2','',5),
 (5,2,'DSK-003','Desk Test 3','Escritorio 3','',4),
 (6,4,'MRM-001','Meeting Room 1','Sala de reuniones 1','',4),
 (7,4,'MRM-002','Meeting room 2','','',4),
 (8,8,'CAR-001','License 8607JGL','','',5),
 (9,5,'ORM-001','Office room 1','','',4),
 (10,8,'CAR_002','License 2536JTR','','[{\"name\":\"files\\/CAR-002_6jsgtd92.png\",\"usrName\":\"CAR-002.png\",\"size\":69791,\"type\":\"image\\/png\",\"searchStr\":\"CAR-002.png,!:sStrEnd\"}]',6);
/*!40000 ALTER TABLE `media` ENABLE KEYS */;


--
-- Definition of table `reservations`
--

DROP TABLE IF EXISTS `reservations`;
CREATE TABLE `reservations` (
  `idreservations` int(11) NOT NULL AUTO_INCREMENT,
  `availability_idavailability` int(11) NOT NULL,
  `media_idmedia` int(10) NOT NULL,
  `users_user_id` int(10) DEFAULT NULL,
  `startDate` datetime NOT NULL,
  `endDate` datetime NOT NULL,
  `effectiveDate` datetime DEFAULT NULL,
  `lastUserUpdated` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `lastDateUpdated` datetime NOT NULL,
  PRIMARY KEY (`idreservations`),
  KEY `fk_reservations_availability1_idx` (`availability_idavailability`),
  KEY `fk_reservations_media1_idx` (`media_idmedia`),
  KEY `fk_reservations_users1_idx` (`users_user_id`),
  CONSTRAINT `fk_reservations_availability1` FOREIGN KEY (`availability_idavailability`) REFERENCES `availability` (`idavailability`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_reservations_media1` FOREIGN KEY (`media_idmedia`) REFERENCES `media` (`idmedia`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_reservations_users1` FOREIGN KEY (`users_user_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL ON UPDATE SET NULL
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `reservations`
--

/*!40000 ALTER TABLE `reservations` DISABLE KEYS */;
INSERT INTO `reservations` (`idreservations`,`availability_idavailability`,`media_idmedia`,`users_user_id`,`startDate`,`endDate`,`effectiveDate`,`lastUserUpdated`,`lastDateUpdated`) VALUES 
 (3,5,1,4,'2020-03-10 08:00:00','2020-03-10 15:00:00','2020-03-10 15:00:00','admin','2020-03-16 12:19:10'),
 (4,5,1,4,'2020-03-10 15:00:00','2020-03-10 16:00:00','2020-03-10 16:00:00','admin','2020-03-16 17:28:03'),
 (5,5,1,4,'2020-03-10 16:00:00','2020-03-10 20:00:00','2020-03-11 08:00:00','admin','2020-03-13 20:45:41'),
 (6,6,2,4,'2020-03-17 11:00:00','2020-03-17 12:00:00','2020-03-17 12:00:00','admin','2020-03-18 13:48:42'),
 (7,13,8,4,'2020-03-18 08:00:00','2020-03-18 18:00:00','2020-03-18 18:00:00','admin','2020-03-17 11:50:20'),
 (8,13,8,4,'2020-03-18 18:00:00','2020-03-18 20:00:00','2020-03-19 08:00:00','admin','2020-03-18 13:49:07'),
 (10,9,5,5,'2020-03-18 08:00:00','2020-03-18 15:00:00','2020-03-18 15:00:00','user1','2020-03-18 18:49:07');
/*!40000 ALTER TABLE `reservations` ENABLE KEYS */;


--
-- Definition of table `reservations_settings`
--

DROP TABLE IF EXISTS `reservations_settings`;
CREATE TABLE `reservations_settings` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `TYPE` int(11) DEFAULT '1',
  `NAME` mediumtext,
  `USERNAME` mediumtext,
  `COOKIE` varchar(500) DEFAULT NULL,
  `SEARCH` mediumtext,
  `TABLENAME` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `reservations_settings`
--

/*!40000 ALTER TABLE `reservations_settings` DISABLE KEYS */;
INSERT INTO `reservations_settings` (`ID`,`TYPE`,`NAME`,`USERNAME`,`COOKIE`,`SEARCH`,`TABLENAME`) VALUES 
 (1,2,NULL,'admin',NULL,'{\"gridWidth\":731.4,\"thWidths\":{\"grid_headcell_icons\":27,\"grid_headcell_checkbox\":13,\"grid_headcell_details\":33.4,\"grid_headcell_field\":10,\"grid_headcell_field1\":81,\"grid_headcell_field2\":56,\"grid_headcell_field3\":72,\"grid_headcell_field4\":77,\"grid_headcell_field5\":66,\"grid_headcell_field6\":65}}','super_catalog'),
 (2,2,NULL,'admin',NULL,'{\"gridWidth\":851.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":19.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":62.4,\"grid_headcell_field2\":235.4,\"grid_headcell_field3\":30.4,\"grid_headcell_field4\":131.4,\"grid_headcell_field5\":110.4,\"grid_headcell_field6\":97.4}}','type_media'),
 (3,2,NULL,'admin',NULL,'{\"gridWidth\":905.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":25.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":268.4,\"grid_headcell_field2\":42.4,\"grid_headcell_field6\":20.4,\"grid_headcell_field11\":61.4,\"grid_headcell_field12\":331.4}}','companies'),
 (4,2,NULL,'admin',NULL,'{\"gridWidth\":931.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":24.4,\"grid_headcell_details\":33.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":68.4,\"grid_headcell_field2\":212.4,\"grid_headcell_field3\":65.4,\"grid_headcell_field4\":139.4,\"grid_headcell_field5\":265.4}}','users'),
 (5,2,NULL,'admin',NULL,'{\"gridWidth\":829.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_details\":-0.6,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":147.4,\"grid_headcell_field2\":156.4,\"grid_headcell_field3\":36.4,\"grid_headcell_field4\":19.4,\"grid_headcell_field5\":145.4,\"grid_headcell_field6\":173.4}}','departments'),
 (6,2,NULL,'admin',NULL,'{\"gridWidth\":914.4,\"thWidths\":{\"grid_headcell_icons\":35.4,\"grid_headcell_checkbox\":16.4,\"grid_headcell_details\":31.4,\"grid_headcell_field\":15.4,\"grid_headcell_field1\":151.4,\"grid_headcell_field2\":59.4,\"grid_headcell_field3\":122.4,\"grid_headcell_field4\":108.4,\"grid_headcell_field6\":136.4,\"grid_headcell_field5\":142.4}}','media'),
 (7,2,NULL,'admin',NULL,'{\"gridWidth\":788.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":19.4,\"grid_headcell_field\":155.4,\"grid_headcell_field1\":249.4,\"grid_headcell_field2\":290.4}}','config'),
 (8,2,NULL,'admin',NULL,'{\"gridWidth\":717.4,\"thWidths\":{\"grid_headcell_icons\":45.4,\"grid_headcell_checkbox\":16.4,\"grid_headcell_details\":62.4,\"grid_headcell_field\":68.4,\"grid_headcell_field1\":227.4,\"grid_headcell_field2\":117.4,\"grid_headcell_field3\":113.4}}','availability'),
 (9,2,NULL,'admin',NULL,'{\"gridWidth\":627.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":14.4,\"grid_headcell_field\":14.4,\"grid_headcell_field1\":72.4,\"grid_headcell_field2\":155.4,\"grid_headcell_field3\":133.4,\"grid_headcell_field4\":144.4}}','reservations'),
 (10,2,NULL,'admin',NULL,'{\"gridWidth\":714.4,\"thWidths\":{\"grid_headcell_icons\":27.4,\"grid_headcell_checkbox\":13.4,\"grid_headcell_field\":12.4,\"grid_headcell_field1\":73.4,\"grid_headcell_field2\":274.4,\"grid_headcell_field3\":119.4,\"grid_headcell_field4\":127.4}}','available_block'),
 (11,2,NULL,'admin',NULL,'{\"gridWidth\":769.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_field\":81.4,\"grid_headcell_field1\":131.4,\"grid_headcell_field2\":136.4,\"grid_headcell_field3\":152.4,\"grid_headcell_field4\":154.4}}','v_reservations'),
 (12,3,'0','admin',NULL,'[\".dummyField\"]','media'),
 (13,3,'0','admin',NULL,'[\".dummyField\"]','availability'),
 (14,2,NULL,'admin',NULL,'{\"gridWidth\":561.4,\"thWidths\":{\"grid_headcell_icons\":20.4,\"grid_headcell_checkbox\":59.4,\"grid_headcell_details\":-0.6,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":50.4,\"grid_headcell_field2\":57.4,\"grid_headcell_field3\":79.4,\"grid_headcell_field4\":91.4,\"grid_headcell_field5\":108.4}}','admin_users'),
 (15,2,NULL,'user2',NULL,'{\"gridWidth\":686.4,\"thWidths\":{\"grid_headcell_icons\":20.4,\"grid_headcell_details\":44.4,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":45.4,\"grid_headcell_field2\":167.4,\"grid_headcell_field3\":30.4,\"grid_headcell_field4\":125.4,\"grid_headcell_field5\":81.4,\"grid_headcell_field6\":76.4}}','type_media'),
 (16,2,NULL,'user2',NULL,'{\"gridWidth\":1130.4,\"thWidths\":{\"grid_headcell_icons\":20.4,\"grid_headcell_details\":58.4,\"grid_headcell_field\":12.4,\"grid_headcell_field1\":240.4,\"grid_headcell_field2\":55.4,\"grid_headcell_field3\":196.4,\"grid_headcell_field4\":148.4,\"grid_headcell_field6\":107.4,\"grid_headcell_field5\":205.4}}','media'),
 (17,2,NULL,'user2',NULL,'{\"gridWidth\":631.4,\"thWidths\":{\"grid_headcell_icons\":20.4,\"grid_headcell_details\":-0.6,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":265.4,\"grid_headcell_field2\":154.4,\"grid_headcell_field3\":125.4}}','availability'),
 (18,2,NULL,'user1',NULL,'{\"gridWidth\":829.4,\"thWidths\":{\"grid_headcell_icons\":26.4,\"grid_headcell_checkbox\":20.4,\"grid_headcell_details\":-0.6,\"grid_headcell_field\":12.4,\"grid_headcell_field1\":298.4,\"grid_headcell_field2\":98.4,\"grid_headcell_field3\":307.4}}','availability'),
 (19,2,NULL,'user1',NULL,'{\"gridWidth\":1075.4,\"thWidths\":{\"grid_headcell_icons\":20.4,\"grid_headcell_details\":58.4,\"grid_headcell_field\":12.4,\"grid_headcell_field1\":139.4,\"grid_headcell_field2\":55.4,\"grid_headcell_field3\":213.4,\"grid_headcell_field4\":102.4,\"grid_headcell_field6\":107.4,\"grid_headcell_field5\":280.4}}','media'),
 (20,2,NULL,'user1',NULL,'{\"gridWidth\":632.4,\"thWidths\":{\"grid_headcell_icons\":20.4,\"grid_headcell_details\":-0.6,\"grid_headcell_field\":9.4,\"grid_headcell_field1\":61.4,\"grid_headcell_field2\":149.4,\"grid_headcell_field3\":30.4,\"grid_headcell_field4\":132.4,\"grid_headcell_field5\":59.4,\"grid_headcell_field6\":84.4}}','type_media');
/*!40000 ALTER TABLE `reservations_settings` ENABLE KEYS */;


--
-- Definition of table `reservations_uggroups`
--

DROP TABLE IF EXISTS `reservations_uggroups`;
CREATE TABLE `reservations_uggroups` (
  `GroupID` int(11) NOT NULL AUTO_INCREMENT,
  `Label` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `reservations_uggroups`
--

/*!40000 ALTER TABLE `reservations_uggroups` DISABLE KEYS */;
/*!40000 ALTER TABLE `reservations_uggroups` ENABLE KEYS */;


--
-- Definition of table `reservations_ugmembers`
--

DROP TABLE IF EXISTS `reservations_ugmembers`;
CREATE TABLE `reservations_ugmembers` (
  `UserName` varchar(300) NOT NULL,
  `GroupID` int(11) NOT NULL,
  PRIMARY KEY (`UserName`(50),`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `reservations_ugmembers`
--

/*!40000 ALTER TABLE `reservations_ugmembers` DISABLE KEYS */;
INSERT INTO `reservations_ugmembers` (`UserName`,`GroupID`) VALUES 
 ('admin',-1);
/*!40000 ALTER TABLE `reservations_ugmembers` ENABLE KEYS */;


--
-- Definition of table `reservations_ugrights`
--

DROP TABLE IF EXISTS `reservations_ugrights`;
CREATE TABLE `reservations_ugrights` (
  `TableName` varchar(300) NOT NULL,
  `GroupID` int(11) NOT NULL,
  `AccessMask` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`TableName`(50),`GroupID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--
-- Dumping data for table `reservations_ugrights`
--

/*!40000 ALTER TABLE `reservations_ugrights` DISABLE KEYS */;
INSERT INTO `reservations_ugrights` (`TableName`,`GroupID`,`AccessMask`) VALUES 
 ('admin_members',-1,'ADESPIM'),
 ('admin_users',-1,'ADESPIM'),
 ('availability',-2,'SM'),
 ('availability',-1,'SM'),
 ('availability_reservation',-2,'S'),
 ('availability_reservation',-1,'S'),
 ('available_block',-1,'ADESP'),
 ('catalog',-1,'ADESPIM'),
 ('companies',-1,'ADESPIM'),
 ('config',-1,'ADESPIM'),
 ('departments',-1,'ADESPIM'),
 ('lv_catalog',-1,'ADESPM'),
 ('lv_type_media',-2,'S'),
 ('media',-2,'S'),
 ('media',-1,'ADESP'),
 ('reservations',-1,'ADESP'),
 ('reservations_cancellation',-2,'S'),
 ('reservations_cancellation',-1,'S'),
 ('super_catalog',-1,'ADESPIM'),
 ('type_media',-2,'S'),
 ('type_media',-1,'AEDSPI'),
 ('users',-1,'ADESPIM'),
 ('v_availability',-2,'S'),
 ('v_availability',-1,'AEDSPI'),
 ('v_reservations',-2,'AES'),
 ('v_reservations',-1,'ADESP');
/*!40000 ALTER TABLE `reservations_ugrights` ENABLE KEYS */;


--
-- Definition of table `super_catalog`
--

DROP TABLE IF EXISTS `super_catalog`;
CREATE TABLE `super_catalog` (
  `idsuper_catalog` int(11) NOT NULL AUTO_INCREMENT,
  `super_code` varchar(20) COLLATE utf8_unicode_ci NOT NULL,
  `description` varchar(100) COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`idsuper_catalog`),
  UNIQUE KEY `super_catalog_ixd1` (`super_code`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `super_catalog`
--

/*!40000 ALTER TABLE `super_catalog` DISABLE KEYS */;
INSERT INTO `super_catalog` (`idsuper_catalog`,`super_code`,`description`) VALUES 
 (1,'LANGUAGE','Languages of the literals'),
 (2,'COMPANY','Type of Companies'),
 (3,'DECISION','Affirmative and negative');
/*!40000 ALTER TABLE `super_catalog` ENABLE KEYS */;


--
-- Definition of table `type_media`
--

DROP TABLE IF EXISTS `type_media`;
CREATE TABLE `type_media` (
  `idtype_media` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(5) COLLATE utf8_unicode_ci NOT NULL,
  `title` varchar(50) COLLATE utf8_unicode_ci NOT NULL,
  `color` varchar(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '#FFFFFF',
  `maxTimeReservation` time NOT NULL,
  `startTimeDay` time NOT NULL,
  `endTimeDay` time NOT NULL,
  PRIMARY KEY (`idtype_media`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `type_media`
--

/*!40000 ALTER TABLE `type_media` DISABLE KEYS */;
INSERT INTO `type_media` (`idtype_media`,`code`,`title`,`color`,`maxTimeReservation`,`startTimeDay`,`endTimeDay`) VALUES 
 (1,'PRKN','Parking','#11F5C0','04:00:00','11:00:00','15:00:00'),
 (2,'DESK','Desk','#D48815','10:00:00','08:00:00','20:00:00'),
 (4,'MROOM','Meeting room','#495DED','08:00:00','08:00:00','20:00:00'),
 (5,'OROOM','Office room','#11DE5C','08:00:00','08:00:00','20:00:00'),
 (6,'PRJT','Projector','#C28BF5','04:00:00','08:00:00','20:00:00'),
 (7,'PC','Laptop','#E86A21','10:00:00','08:00:00','20:00:00'),
 (8,'CAR','Car','#050505','10:00:00','08:00:00','20:00:00');
/*!40000 ALTER TABLE `type_media` ENABLE KEYS */;


--
-- Definition of table `users`
--

DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `user_id` int(10) NOT NULL AUTO_INCREMENT,
  `login` varchar(16) COLLATE utf8_unicode_ci NOT NULL,
  `companies_company_id` int(10) NOT NULL DEFAULT '0',
  `departments_dept_id` int(10) unsigned DEFAULT NULL,
  `username` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `password` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `signature` mediumtext COLLATE utf8_unicode_ci,
  `email` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `color_identifier` varchar(7) COLLATE utf8_unicode_ci NOT NULL DEFAULT '#FFFFFF',
  `reset_token` varchar(50) COLLATE utf8_unicode_ci DEFAULT NULL,
  `reset_date` datetime DEFAULT NULL,
  PRIMARY KEY (`user_id`),
  KEY `user_username` (`username`),
  KEY `fk_users_companies1_idx` (`companies_company_id`),
  KEY `user_login` (`login`),
  CONSTRAINT `fk_users_companies1` FOREIGN KEY (`companies_company_id`) REFERENCES `companies` (`company_id`) ON DELETE NO ACTION ON UPDATE NO ACTION
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

--
-- Dumping data for table `users`
--

/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` (`user_id`,`login`,`companies_company_id`,`departments_dept_id`,`username`,`password`,`signature`,`email`,`color_identifier`,`reset_token`,`reset_date`) VALUES 
 (4,'admin',3,NULL,'Admistrator','21232f297a57a5a743894a0e4a801fc3',NULL,'info@fhumanes.com','#FFFFFF',NULL,NULL),
 (5,'user1',3,1,'User 1','24c9e15e52afc47c225b757e7bee1f9d',NULL,'','#E31C1C',NULL,NULL),
 (6,'user2',3,NULL,'User 2','7e58d63b60197ceb55a1c487989a3720',NULL,'','#1944D1',NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;




/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
